<?php

namespace Discovereel\Users;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function reels()
    {
        return $this->hasMany('Reel');
    }

    public function roles()
    {
        return $this->belongsToMany('Role')->withTimestamps();
    }

}